      // ShoppingBasket.js

      function ShoppingBasket() 
      {
         this.items = new Object();
         this.numItems = 0;
         this.deliveryCost = "2.50";
      }


      function ShoppingItem(itemRefId, itemArtist, itemDesc, 
         itemPrice, itemQty)
      {
         this.itemRefId = itemRefId;
         this.itemArtist = itemArtist;
         this.itemDesc = itemDesc;
         this.itemPrice = itemPrice;
         this.itemQty = itemQty;
      }

      ShoppingItem.prototype.getItemRefId = function()
      {
         return this.itemRefId;
      }

      ShoppingItem.prototype.setItemRefId = function(itemRefId)
      {
         this.itemRefId = itemRefId;
      }

      ShoppingItem.prototype.getItemArtist = function()
      {
         return this.itemArtist;
      }

      ShoppingItem.prototype.setItemArtist = function(itemArtist)
      {
         this.itemArtist = itemArtist;
      }


      ShoppingItem.prototype.getItemDesc = function()
      {
         return this.itemDesc;
      }

      ShoppingItem.prototype.setItemDesc = function(itemDesc)
      {
         this.itemDesc = itemDesc;
      }


      ShoppingItem.prototype.getItemPrice = function()
      {
         return this.itemPrice;
      }

      ShoppingItem.prototype.setItemPrice = function(itemPrice)
      {
         this.itemPrice = Number(itemPrice);
      }


      ShoppingItem.prototype.getItemQty = function()
      {
         return this.itemQty;
      }

      ShoppingItem.prototype.setItemQty = function(itemQty)
      {
         this.itemQty = Number(itemQty);
      }

      ShoppingBasket.prototype.addItem = function(itemRefId, itemArtist, 
         itemDesc, itemPrice, itemQty) 
      {
         if (typeof(this.items[itemRefId]) == "undefined")
         {
            this.items[itemRefId] = new 
              ShoppingItem(itemRefId,itemArtist,itemDesc,itemPrice,itemQty);
            this.numItems++;
         }
         else
         {
            this.items[itemRefId].setItemQty(itemQty);
         }
      }

      ShoppingBasket.prototype.deleteItem = function(itemRefId)
      {
	
	if (typeof(this.items[itemRefId]) != "undefined")         
	{
		delete this.items[itemRefId];
        	this.numItems--;
	}
      }

      ShoppingBasket.prototype.fixDecimalPlaces = function 
         (fixNumber, decimalPlaces)
      {
         
	
	var lDiv = Math.pow(10,decimalPlaces);
         fixNumber = new String((Math.round(fixNumber * (lDiv)))/lDiv)

	 var zerosRequired;
	 var decimalPointLocation = fixNumber.lastIndexOf(".");
         if (decimalPointLocation == -1)
	 {
       		fixNumber = fixNumber + ".";
       		zerosRequired = decimalPlaces;
	}
	else
      	{
 		zerosRequired = decimalPlaces - (fixNumber.length - decimalPointLocation - 1);
       	}

         for (; zerosRequired > 0; zerosRequired--)
       	    fixNumber = fixNumber + "0";

         return fixNumber;

      }

      ShoppingBasket.prototype.getBasketHTML = function(isBasketUpdateable)
      {
         var basketHTML = "";
         if (isBasketUpdateable)
         {
            basketHTML = "<FORM name=basketForm>";
         }
         basketHTML += "<TABLE class=BasketTable><TR class=HeadTR>";
         basketHTML += "<TH class=BasketHeading>Artysta</TH>";
         basketHTML += "<TH class=BasketHeading>Tytu</TH>";
         basketHTML += "<TH class=BasketHeading>Cena jedn.</TH>";
         basketHTML += "<TH class=BasketHeading>Ilo</TH>";
         basketHTML += "<TH class=BasketHeading>Cena kocowa</TH></TR>";
         var basketItem;
         var basketTotalCost = 0;
         var itemTotalCost = 0;

         for (basketItem in this.items)
         {
            // Artysta
            basketHTML += "<TR><TD ALIGN=CENTER CLASS=Artist>";
            basketHTML += this.items[basketItem].getItemArtist();
            basketHTML += "</TD>";

            // Opis
            basketHTML += "<TD ALIGN=CENTER CLASS=Title>";
            basketHTML += this.items[basketItem].getItemDesc();
            basketHTML += "</TD>";

            // Cena
            basketHTML += "<TD ALIGN=CENTER CLASS=Price>";
            basketHTML += this.items[basketItem].getItemPrice();
            basketHTML += "</TD>";

            // Ilo
            basketHTML += "<TD ALIGN=CENTER CLASS=Price>";

            if (isBasketUpdateable)
            {
               basketHTML += "<INPUT type=text size=2 maxlength=2 name='" + 
                  this.items[basketItem].getItemRefId() + "' ";
               basketHTML += "VALUE=" + this.items[basketItem].getItemQty();
               basketHTML += ">";
            }
            else
            {
               basketHTML += this.items[basketItem].getItemQty();
            }
            basketHTML += "</TD>";

            itemTotalCost = this.items[basketItem].getItemQty() * 
               this.items[basketItem].getItemPrice();

            basketTotalCost += itemTotalCost;

            // Pena cena towaru
            basketHTML += "<TD ALIGN=CENTER class=Price>";
            basketHTML += this.fixDecimalPlaces(itemTotalCost, 2);
            basketHTML += "</TD>";

            basketHTML += "</TR>";
         }

         
         // Podsumowanie kosztw
         basketHTML += "<TR><TD COLSPAN=4 ALIGN=RIGHT class=BasketSummary "
            "style='padding-top: 10px'>";
         basketHTML += "Sub Total</TD>";
         basketHTML += "<TD ALIGN='CENTER' CLASS= "
            + "'BasketSummary STYLE='padding-top: 10px'>";
         basketHTML += this.fixDecimalPlaces(basketTotalCost,2);
	 basketHTML += "</TD></TR>"
         basketHTML += "<TR><TD COLSPAN=4 ALIGN=RIGHT "
            +"CLASS='BasketSummary'>Przesyka</TD>";
         basketHTML += "<TD  ALIGN=CENTER class=BasketSummary>" 
            + this.deliveryCost + "</TD></TR>";
         basketHTML += "<TR><TD COLSPAN=4 ALIGN=RIGHT "
            + "CLASS='BasketSummary'>Suma kocowa</TD>";
         basketHTML += "<TD ALIGN=CENTER class=BasketSummary>" 
         basketHTML += this.fixDecimalPlaces(basketTotalCost + 
				Number(this.deliveryCost), 2);
         basketHTML += "</TD></TR></TABLE>";

         if (isBasketUpdateable)
         {
            basketHTML += "<P>Jeli zmienisz ilo towaru, kliknij ";
            basketHTML += "<INPUT NAME='Submit' TYPE='submit' " 
               +"VALUE='Popraw ilo' ";
            basketHTML += "onClick='updateBasket()'>";
            basketHTML += "<BR>Aby usun towar, ustaw jego ilo na 0" 
               +"</P></FORM>";
         }
         return basketHTML;
      }

      ShoppingBasket.prototype.isEmpty = function()
      {
         if (this.numItems < 1)
         {
            return true;
         }
         else
         {
            return false;
         }
      }

      ShoppingBasket.prototype.setQty = function(itemRefId, itemQty)
      {
         if (itemQty < 1)
         {
            this.deleteItem(itemRefId);
         }
         else
         {
           this.items[itemRefId].setItemQty(itemQty);
         }
      }

      ShoppingBasket.prototype.updateBasketWithForm = function(basketForm)
      {
         var itemRefId;
         var numFormElements = basketForm.length;
         var basketFormElements = basketForm.elements;
         for (var elementIndex = 0; elementIndex < numFormElements; 
            elementIndex++)
         {
            if (basketFormElements[elementIndex].type == "text")
            {
               itemRefId = basketFormElements[elementIndex].name;
               itemQty = parseInt(basketFormElements[elementIndex].value);
               if (!isNaN(itemQty))
               {
                  this.setQty(itemRefId,itemQty);
               }
            }
         }
      }

      ShoppingBasket.prototype.saveBasket = function()
      {
         if (!this.isEmpty())
         {
            var basketDetails = "";
            var cookieExpires;

            for (basketItem in this.items)
            {
               basketDetails += this.items[basketItem].getItemRefId() + "`";
               basketDetails += this.items[basketItem].getItemArtist() 
                  + "`";
               basketDetails += this.items[basketItem].getItemDesc() + "`";
               basketDetails += this.items[basketItem].getItemPrice() + "`";
               basketDetails += this.items[basketItem].getItemQty() + "";
            }

            basketDetails = 
               basketDetails.substring(0,basketDetails.length - 1);

            basketDetails = escape(basketDetails);
            var nowDate = new Date();
            nowDate.setMonth(nowDate.getMonth() + 3);
            cookieExpires = nowDate.toGMTString();

            document.cookie = "MusicMadBasket=" + basketDetails 
               + ";expires=" + cookieExpires + ";";
         }
         else
         {
            document.cookie = "MusicMadBasket= " 
               +";expires=1 Jan 2000 00:00:00";
         }
      }

      ShoppingBasket.prototype.getCookieValue = function(cookieName)
      {
         var cookieValue = document.cookie;
         var cookieRegExp = new RegExp("\\b" + cookieName + "=([^;]+)");
         cookieValue = cookieRegExp.exec(cookieValue);

         if (cookieValue != null)
         {
            cookieValue = cookieValue[1];
            cookieValue = unescape(cookieValue);
         }

         return cookieValue;
      }

      ShoppingBasket.prototype.loadBasket = function()
      {
         var basketItems;
         var basketItemNum;
         var itemDetail;
         var itemRefId = "";
         var itemArtist = "";
         var itemDesc = "";
         var itemPrice = "";
         var itemQty = "";

         var basketDetails = this.getCookieValue("MusicMadBasket");
         if (basketDetails != null)
         {
            basketItems = basketDetails.split('');

            for (basketItemNum in basketItems)
            {
               basketItem = basketItems[basketItemNum];
               basketItem = basketItem.split('`');

               itemRefId = basketItem[0];
               itemArtist = basketItem[1];
               itemDesc =basketItem[2];
               itemPrice = basketItem[3];
               itemQty = basketItem[4];
               this.addItem(itemRefId, itemArtist,itemDesc,itemPrice, 
                  itemQty);
            }
         }
      }


ShoppingBasket.prototype.getTotalIncDelivery = function()
{
   var basketTotalCost = 0;
   var basketItem;
   var itemTotalCost = 0;
   
   for (basketItem in this.items)
   {
      itemTotalCost = this.items[basketItem].getItemQty() * 
         this.items[basketItem].getItemPrice();
      basketTotalCost += itemTotalCost
   }

   basketTotalCost += Number(this.deliveryCost);
   basketTotalCost = this.fixDecimalPlaces(basketTotalCost,2);
   return basketTotalCost;

}

ShoppingBasket.prototype.getHiddenInputHTML = function()
{
   var hiddenInputHTML = "";
   var basketItem;
   
   for (basketItem in this.items)
   {
      // Identyfikator
      hiddenInputHTML += "<INPUT TYPE='hidden' NAME='"; 
      hiddenInputHTML += this.items[basketItem].getItemRefId() + "_RefId'";
      hiddenInputHTML += " value=" + this.items[basketItem].getItemRefId();
      hiddenInputHTML += ">";

      // Ilo
      hiddenInputHTML += "<INPUT TYPE='hidden' NAME='"; 
      hiddenInputHTML += this.items[basketItem].getItemRefId() + "_Qty'";
      hiddenInputHTML += " value=" + this.items[basketItem].getItemQty();
      hiddenInputHTML += ">";
   }
   
   return hiddenInputHTML;
}

ShoppingBasket.prototype.clearBasket = function()
{
   this.items = new Object();
   this.numItems = 0;
   document.cookie = "MusicMadBasket= ;expires=1 Jan 2000 00:00:00";
}
